set sql_safe_updates=0;
SET @dataproviderId2=(SELECT id FROM dydt_data_provider WHERE `providerName`='Student Hostel Details Provider');
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'select
    T6.roomNumber AS Student_Hostel_RoomNumber,
    T7.roomType AS Student_Hostel_RoomType,
    T9.addressText AS student_Permanent_Address,
    T5.checkInDate AS Hostel_CheckIn_Date,
    personserv2_.fromDate AS Service_From_Date,
    personserv2_.tillDate AS Service_End_Date,
    feeplan8_.feePlanName as Fee_Plan_Name,
	billheader3_.totalAmount as Fee_Amount 
    from 
    admission T1
    left join
        students this_ on this_.userId =T1.studentId
    inner join
        users this_1_ 
            on this_.userId=this_1_.id 
          LEFT JOIN 
	hostel_room_allotment T5 ON T5.studentId = this_1_.id
        LEFT JOIN
    hostel_room T6 ON T6.id = T5.roomId
        LEFT JOIN
    hostel_room_type T7 ON T7.id = T6.roomTypeId
        LEFT JOIN
    person_addresses T8 ON T8.personId = this_1_.id
        LEFT JOIN
    address T9 ON T9.id = T8.addressId and T8.addressTypeId = 7       
    left outer join
        bill_header billheader3_ 
            on this_.userId=billheader3_.studentId 
    left outer join
        bill_fee_plan_rule_stage billfeepla4_ 
            on billheader3_.id=billfeepla4_.billId 
    left outer join
        fee_stage_head_config feestagehe5_ 
            on billfeepla4_.feeStageHeadConfigId=feestagehe5_.id 
    left outer join
        fee_plan_rule_stage feeplanrul6_ 
            on feestagehe5_.feePlanRuleStageId=feeplanrul6_.id 
    left outer join
        fee_plan_rules feeplanrul7_ 
            on feeplanrul6_.feePlanRuleId=feeplanrul7_.id 
    left outer join
        fee_plan feeplan8_ 
            on feeplanrul7_.feePlanId=feeplan8_.id 
    left outer join
        service feeplanser9_ 
            on feeplan8_.serviceId=feeplanser9_.id 
    left outer join
        persons person1_ 
            on this_.personId=person1_.id 
    left outer join
        person_services personserv2_ 
            on person1_.id=personserv2_.personId 
    left outer join
        service service10_ 
            on personserv2_.serviceId=service10_.id ',
    
    `resultColumnsDef` = 'Student_Hostel_RoomNumber,Student_Hostel_RoomType,student_Permanent_Address,Hostel_CheckIn_Date,Service_From_Date,Service_End_Date,Fee_Plan_Name,Fee_Amount',
    `sqlWhereQueryDef` = 'WHERE lower(feeplanser9_.serviceName) like "Hostel"
        and billheader3_.raiseBillType= "SERVICE_PROVIDED"
        and lower(service10_.serviceName) like "Hostel"
        and personserv2_.whetherOpted=true 
        and personserv2_.status="ACTIVE"
        and personserv2_.whetherDeleted=false 
        and this_1_.status= true
        and this_1_.whetherDeleted=false
        and T1.id=PRM_ADMISSION_ID order by billheader3_.lastUpdate desc '
WHERE
    `dataSourceCode` = 'SUTDENT_HOSTEL_DETAILS_INFO' AND dataProviderId = @dataproviderId2;
set sql_safe_updates=1;

#------------------TRANSLATIONS---------------------
   
	SET @dydtdatalinitemId=(SELECT id FROM `dydt_data_line_item` where dataSourceCode='SUTDENT_HOSTEL_DETAILS_INFO');
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES ('Student_Hostel_RoomNumber', 'Student Hostel Room Number',@dydtdatalinitemId),
    ('Student_Hostel_RoomType', 'Student Hostel Room Type',@dydtdatalinitemId),
    ('student_Permanent_Address', 'Student Permanent Address',@dydtdatalinitemId),
    ('Hostel_CheckIn_Date', 'Hostel Check In Date',@dydtdatalinitemId),
    ('Service_From_Date', 'Hostel Service start date',@dydtdatalinitemId),
    ('Service_End_Date', 'Hostel Service end date',@dydtdatalinitemId),
    ('Fee_Plan_Name', 'Student Hostel Fee Plan Name',@dydtdatalinitemId),
    ('Fee_Amount', 'Student Hostel Fee Plan Amount',@dydtdatalinitemId);
